﻿var libraryBrowser = {
    container: null,
    itemInPreview: null,
    questionnaireId: 0,
    selectedItem: 0,
    selectedPublicSource: false,
    isThemeBrowser: false,
    themeRowNbItems: 3,
    themeQuestionId: 0,
    themeBlockId: 0,
    reloadThemeBrowser: false
};

function InitLibraryBrowser(container, questionnaireId) {
    libraryBrowser.container = container;
    libraryBrowser.questionnaireId = questionnaireId;
    libraryBrowser.isThemeBrowser = $(".v-libraryBrowserPanel", container).length > 0;

    if (libraryBrowser.isThemeBrowser) {
        libraryBrowser.themeRowNbItems = ($(window).width() <= 1300) ? 3
                                            : ($(window).width() <= 1600) ? 4 : 5;

        var previewQuestion = $(".v-previewZoneContainer .v-itemContainer:visible:first", container);

        if (previewQuestion.length > 0) {
            libraryBrowser.themeQuestionId = previewQuestion.attr("id").replace("Question", "");
            libraryBrowser.themeBlockId = previewQuestion.attr("data-block");
        }
    }
}

function InitializeImportQuestions() {
    SetImportQuestionsEvents();
}

function SetImportQuestionsEvents() {
    // click on folder
    libraryBrowser.container.on("click", ".v-libraryBrowserPanel .v-library .v-folder", function (event) {
        var folder = $(this);

        $.each($(".v-libraryBrowserPanel .v-library .v-folder", libraryBrowser.container), function () {
            $(this).closest("li").removeClass("selected");
        });

        folder.closest("li").addClass("selected");

        libraryBrowser.selectedPublicSource = (folder.attr("data-section") == "PublicLibrary");

        if (folder.attr("data-id") != undefined && libraryBrowser.isThemeBrowser) {
            LoadTemplateScrollable(folder);
        }
        else {
            //LoadFolderContent(folder, function () { ExpandFolder(folder); });
        }
    });
}

function LoadTemplateScrollable(folder) {
    var section = folder.attr("data-section");
    var container = $(".v-templateBrowserItems", folder.closest(".v-templateBrowser"));
    var previewZone = $(".v-items", container);
    var categoryId = folder.attr("data-id");
    var args = { questionnaireId: libraryBrowser.questionnaireId, blockId: libraryBrowser.themeBlockId, questionId: libraryBrowser.themeQuestionId, nbItems: libraryBrowser.themeRowNbItems, section: section, categoryId: categoryId };

    //previewZone.html($(".h-waitingIcon:first", container).clone().show());

    a4.callServerMethod(a4.getAction("GetLibraryBrowserTemplates", "LookAndFeel", "Survey"), args,
        function (result) {
            previewZone.html(result);
            //InitTemplatesScrollable(container);
        },
        function (error) {
            a4.onAjaxPageMethodError(error);
        },
        { blockElement: $(".v-templateBrowserItems", themeEditor.container) }
	);
}